// standard library
#include <iostream>
#include <string>
#include <typeinfo>
// STL
#include <list>
#include <vector>
#include <deque>
#include <algorithm>
// go on and pollute the global namespace
using namespace std;

// nested sequences template class
#include "nseq.hpp"
// pollute the global namespace again
using namespace wsi;

// allocate memory with new in chunks
//#include "smartnew.h"

void display_sizes()
{
  // display sizeof constants for typical types
  cout << "sizeof(bool)           " << sizeof(bool) << endl;
  cout << "sizeof(elem<bool>)     " << sizeof(elem<bool>) << endl;
  cout << "sizeof(char)           " << sizeof(char) << endl;
  cout << "sizeof(elem<char>)     " << sizeof(elem<char>) << endl;
  cout << "sizeof(int)            " << sizeof(int) << endl;
  cout << "sizeof(elem<int>)      " << sizeof(elem<int>) << endl;
  cout << "sizeof(long)           " << sizeof(long) << endl;
  cout << "sizeof(elem<long>)     " << sizeof(elem<long>) << endl;
  cout << "sizeof(float)          " << sizeof(float) << endl;
  cout << "sizeof(elem<float>)    " << sizeof(elem<float>) << endl;
  cout << "sizeof(double)         " << sizeof(double) << endl;
  cout << "sizeof(elem<double>)   " << sizeof(elem<double>) << endl;
  cout << "sizeof(string)         " << sizeof(string) << endl;
  cout << "sizeof(elem<string>)   " << sizeof(elem<string>) << endl;
  cout << "sizeof(list<int>)      " << sizeof(list<int>) << endl;
  cout << "sizeof(list<double>)   " << sizeof(list<double>) << endl;
  cout << "sizeof(nseq<list>)     " << sizeof(nseq<list>) << endl;
  cout << "sizeof(vector<int>)    " << sizeof(vector<int>) << endl;
  cout << "sizeof(vector<double>) " << sizeof(vector<double>) << endl;
  cout << "sizeof(nseq<vector>)   " << sizeof(nseq<vector>) << endl;
  cout << "sizeof(deque<int>)     " << sizeof(deque<int>) << endl;
  cout << "sizeof(deque<double>)  " << sizeof(deque<double>) << endl;
  cout << "sizeof(nseq<deque>)    " << sizeof(nseq<deque>) << endl;
  cout << "sizeof(base_elem)      " << sizeof(base_elem) << endl;
  cout << endl;
}

// function objects for the examples -------------------------------------------
template <template<class T, class A> class C>
struct print_atom
{
  void operator()(base_elem *el)
  {
    if (el->is_atom())
      cout << *el << " ; ";
    else
      cout << "[" << dynamic_cast<nseq<C>*>(el)->size() << "] ; ";
  }
};

struct work_on
{
  elem<int> *intp;
  elem<float> *fltp;
  elem<double> *dp;
  elem<string> *strp;
  void operator()(base_elem * el)
  {
    if (intp = dynamic_cast< elem< int > *>(el))
      //*intp = intp->getValue() * intp->getValue();
      *intp = *intp * *intp;
    if (fltp = dynamic_cast< elem< float > *>(el))
      *fltp = *fltp + *fltp;
    if (dp = dynamic_cast< elem< double > *>(el))
      *dp = -(*dp);
    if (strp = dynamic_cast< elem< string > *>(el))
      //*strp = strp->getValue() + *strp->getValue();
      *strp = (string) *strp + (string) *strp;
  }
};

// -------------------- example 1 --------------------
void example1()
{
  cout << "-------------------- example 1 --------------------" << endl;
  typedef nseq< list >::const_iterator nseq_clit;
  typedef nseq< vector >::const_iterator nseq_cvit;
  elem<int> *intp;
  
  nseq<list> nl;

  nl.push_back(new elem<int>(11));
  nl.push_back(new elem<int>(22));
  nl.push_back(new elem<string>("mixed"));
  nl.push_back(new elem<int>(33));
  nl.push_back(new elem<string>("string"));
  nl.push_back(new elem<double>(3.14159265358));
  cout << "nl (original):\n" << nl << endl;

  for (nseq_clit nli = nl.begin(); nli != nl.end(); nli++) {
    if (intp = dynamic_cast< elem< int > *>(*nli))
      *intp = intp->getValue() * intp->getValue();
  }
  cout << "nl (updated [1]):\n" << nl << endl;

  cout << "nl (cloned):\n" << nl.clone() << endl;

  nl.push_back(nl.clone());
  nseq<list> *nlp_e = new nseq<list>;
  nlp_e->push_back(new nseq<list>);
  nlp_e->push_back(nlp_e->clone());
  nl.push_back(nlp_e);
  nl.push_back(new nseq<list>);
  cout << "nl (updated [2]):\n" << nl << endl;

  nseq<list>::iterator d(nl.begin());
  for (; d != nl.end(); ++d) {
    if (intp = dynamic_cast< elem< int > * >(*d))
      *intp = intp->getValue() * intp->getValue();
  }
  cout << "nl (updated [3]):\n" << nl << endl;

  for (flat_iterator< nseq< list > > f(nl.begin()); f != nl.end(); ++f) {
    if (intp = dynamic_cast< elem< int > * >(*f))
      *intp = intp->getValue() * intp->getValue();
  }
  cout << "nl (updated [4]):\n" << nl << endl;

  cout << endl << "testing STL with falt_iterator" << endl;
  flat_iterator< nseq< list > > f1 = nl.begin();
  flat_iterator< nseq< list > > f2 = nl.end();
  for_each(f1, f2, work_on());
  cout << "nl (updated [5]):" << endl;
  for_each(f1, f2, print_atom<list>());
  cout << endl;
  cout << endl;

  vector<base_elem*> nbv;
  copy(f1, f2, back_inserter(nbv));
  cout << "nbv (nl flat back inserted):" << endl;
  for (vector<base_elem*>::iterator v_i = nbv.begin(); v_i != nbv.end(); v_i++)
    cout << **v_i << endl;
  cout << endl;
}

void example2()
{
  // -------------------- example 2 --------------------
  cout << "-------------------- example 2 --------------------" << endl;
  nseq<std::vector> nv, nv2;

  elem<string>* s1 = new elem<string>("Hello");
  elem<string>* s2 = new elem<string>("World");
  elem<string> s3("loser");
  elem<int>* i1 = new elem<int>(4711);
  elem<int>* i2 = new elem<int>(-6789);
  elem<int> i3(-815);
  elem<string>* a2 = new elem<string>("done!");
  elem<double>* a1 = new elem<double>(12.7);
  elem<string>* sc1 = s1->clone();
  elem<string>* sc2 = s2->clone();

  nv2.push_back(i1);
  nv2.push_back(sc2);
  nv2.push_back(sc1);
  nv2.push_back(i2);
  nv2.push_back(&s3);

  nv.push_back(s1);
  nv.push_back(s2);
  nv.push_back(i1);
  nv.push_back(s1);
  nv.push_back(i2);
  nv.push_back(&nv2);
  nv.push_back((&nv2)->clone());
  nv.push_back(&i3);
  nv.push_back(a1);
  nv.push_back(a2);

  cout << "nv.size(): " << nv.size() << endl;
  cout << "nv:\n" << nv << endl;
  cout << endl;
}

// run the examples -----------------------------------------------------
int main()
{
  display_sizes();
  example1();
  example2();

  return EXIT_SUCCESS;
}
