//#include "smartnew.h"
#include "smartnew.hpp"

#include <iostream>
#include <string>
#include <list>
#include <vector>
#include <deque>
#include <typeinfo>
#include <algorithm>
using namespace std;

#include "nseq.hpp"
#include "Clock.cpp"

using namespace wsi;

const size_t test_size = 40000;

// ----------------------------------------------------------------------
int main() {
  // -------------------- typedefs --------------------
  typedef nseq< list >::const_iterator nseq_clit;
  typedef nseq< vector >::const_iterator nseq_cvit;
  elem<int> *intp;
  elem<double> *dblp;

  // -------------------- performance tests --------------------
  Clock start, end;
  char c;

  // ---------- list ----------
  {
    cout << "filling list<int> with " << test_size << " elements" << endl;
    list<int> tl;
    start.refresh();
    for (int i = 0; i < test_size; ++i) {
      tl.push_back(i);
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl;
    
    cout << "accessing list<int> with " << test_size << " elements" << endl;
    start.refresh();
    for (list<int>::iterator nli = tl.begin(); nli != tl.end(); nli++) {
      *nli = *nli * *nli;
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl << endl;
    start.refresh();
  }

  {
    cout << "filling nseq<list> with " << test_size << " elements [int]"
	 << endl;
    nseq<list> tl;
    start.refresh();
    for (int i = 0; i < test_size; ++i) {
      tl.push_back(new elem<int>(i));
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl;

    cout << "accessing nseq<list> with " << test_size << " elements [int]"
	 << endl;
    start.refresh();
    for (nseq_clit nli = tl.begin(); nli != tl.end(); nli++) {
      if (intp = dynamic_cast< elem< int > *>(*nli))
	*intp = intp->getValue() * intp->getValue();
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl << endl;
  }

  {
    cout << "filling list<string> with " << test_size << " elements" << endl;
    start.refresh();
    list<string> tl;
    for (int i = 0; i < test_size; ++i) {
      tl.push_back(string("Authors: Volker Simonis, Roland Weiss"));
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl;

    cout << "accessing list<string> with " << test_size << " elements" << endl;
    start.refresh();
    for (list<string>::iterator it = tl.begin(); it != tl.end(); it++) {
      *it = *it + " The C++ wizards...";
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl << endl;
    start.refresh();
  }

  {
    cout << "filling nseq<list> with " << test_size << " elements [string]"
	 << endl;
    start.refresh();
    nseq<list> tl;
    for (int i = 0; i < test_size; ++i) {
      tl.push_back(new elem<string>("Authors: Volker Simonis, Roland Weiss"));
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl;

    cout << "accessing nseq<list> with " << test_size << " elements [string]"
	 << endl;
    elem<string> *strp;
    start.refresh();
    for (nseq_clit it = tl.begin(); it != tl.end(); it++) {
      if (strp = dynamic_cast< elem< string > *>(*it))
	*strp = strp->getValue() + " The C++ wizards...";
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl << endl;
    start.refresh();
  } 

  /*
  // ---------- vector ----------
  {
    cout << "filling vector<int> with " << test_size << " elements" << endl;
    vector<int> tl;
    tl.reserve(test_size);
    start.refresh();
    for (int i = 0; i < test_size; ++i) {
      tl.push_back(i);
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl;
    
    cout << "accessing vector<int> with " << test_size << " elements" << endl;
    start.refresh();
    for (vector<int>::iterator nli = tl.begin(); nli != tl.end(); nli++) {
      *nli = *nli * *nli;
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl << endl;
    start.refresh();
  }

  {
    cout << "filling nseq<vector> with " << test_size << " elements [int]"
	 << endl;
    nseq<vector> tl;
    tl.reserve(test_size);
    start.refresh();
    for (int i = 0; i < test_size; ++i) {
      tl.push_back(new elem<int>(i));
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl;

    cout << "accessing nseq<vector> with " << test_size << " elements [int]"
	 << endl;
    start.refresh();
    for (nseq_cvit nli = tl.begin(); nli != tl.end(); nli++) {
      if (intp = dynamic_cast< elem< int > *>(*nli))
	*intp = intp->getValue() * intp->getValue();
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl << endl;
  }
  {
    cout << "filling nseq<vector> with " << test_size << " elements [double]"
	 << endl;
    nseq<vector> tl;
    tl.reserve(test_size);
    start.refresh();
    for (int i = 0; i < test_size; ++i) {
      tl.push_back(new elem<double>(i));
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl;

    cout << "accessing nseq<vector> with " << test_size << " elements [double]"
	 << endl;
    start.refresh();
    for (nseq_cvit nli = tl.begin(); nli != tl.end(); nli++) {
      if (dblp = dynamic_cast< elem< double > *>(*nli))
	*dblp = dblp->getValue() * dblp->getValue();
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl << endl;
  }

  {
    cout << "filling vector<string> with " << test_size << " elements" << endl;
    start.refresh();
    vector<string> tl;
    tl.reserve(test_size);
    for (int i = 0; i < test_size; ++i) {
      tl.push_back(string("Authors: Volker Simonis, Roland Weiss"));
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl;
    //cout << tl.capacity() << endl;

    cout << "accessing vector<string> with " << test_size << " elements" << endl;
    start.refresh();
    for (vector<string>::iterator it = tl.begin(); it != tl.end(); it++) {
      *it = *it + " The C++ wizards...";
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl << endl;
    start.refresh();
  }

  {
    cout << "filling nseq<vector> with " << test_size << " elements [string]"
	 << endl;
    start.refresh();
    nseq<vector> tl;
    tl.reserve(test_size);
    for (int i = 0; i < test_size; ++i) {
      tl.push_back(new elem<string>("Authors: Volker Simonis, Roland Weiss"));
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl;

    cout << "accessing nseq<vector> with " << test_size << " elements [string]"
	 << endl;
    elem<string> *strp;
    start.refresh();
    for (nseq_cvit it = tl.begin(); it != tl.end(); it++) {
      if (strp = dynamic_cast< elem< string > *>(*it))
	*strp = strp->getValue() + " The C++ wizards...";
    }
    end.refresh();
    cout << "runtime: " << start.diff(end) << " ms" << endl << endl;
    start.refresh();
  }
  */

  return 0;
}
