///////////////////////////////////////////////////////////////////////////////
//
// Clock.hpp - multiplatform Clock class (interface)
//
// last updated: Mon 12/06/1999
//
// +--------------------------------------------------------------------------+
// | Roland Weiss, WSI-CA         | eMail: weissr@informatik.uni-tuebingen.de |
// | University of Tuebingen      |      : weissr@uni-tuebingen.de            |
// | Sand 13, Room 218            |      : roland.weiss@uni-tuebingen.de      |
// | 72076 Tuebingen, Germany     | Tel  : +49 (0)7071 2974009                |
// |                              | Fax  : +49 (0)7071 295958                 |
// | WWW: http://www-ca.informatik.uni-tuebingen.de/people/weissr/weissr.html |
// +--------------------------------------------------------------------------+
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _WSI_CLOCK_HPP_
#define _WSI_CLOCK_HPP_

// ----- includes for time measurement -----
#ifdef _WIN32 // Windows
  #include <sys/timeb.h>
#else         // Unix
  #include <sys/times.h>
  #include <unistd.h>
#endif

// define constants which hold the name of the system specific names
// RW_TIME_STRUCT: name of the time structure
// RW_TIME_FUNC: name of the function which fills the time structure

#ifdef _WIN32 // Windows
  #if defined(_MSC_VER) // Visual C++
    #define RW_TIME_FUNC _ftime
    #define RW_TIME_STRUCT _timeb
  #else // gcc, Borland C++, Visual Age C++
    #define RW_TIME_FUNC ftime
    #define RW_TIME_STRUCT timeb
  #endif
#else         // Unix
  #define RW_TIME_FUNC times
  #define RW_TIME_STRUCT tms
#endif

namespace wsi {

class Clock {
public:
  // default constructor, initializes internal data to current time
  Clock();
  // copy constructor, sets new Clock object's time to given one
  Clock(const Clock& cl);

  // asignment operator, sets new Clock object's time to given one
  Clock& operator=(const Clock& cl);

	// relational operator, test two Clock objects against each other
	// e.g. the operator < return true, if the first object's internal
	// time is earlier than the second one's internal time
  bool operator==(const Clock& cl);
  bool operator<(const Clock& cl);
  bool operator>(const Clock& cl);
  bool operator<=(const Clock& cl);
  bool operator>=(const Clock& cl);

	// reset the Clock object's internal time to the current one
  void refresh();

  // calculate the period of time passed between two clock instances in ms
  unsigned long diff(const Clock& cl);
  unsigned long operator-(const Clock& cl) { return diff(cl); }

private:
  // object's internal time
  struct RW_TIME_STRUCT clock;

  // on Unix stations, the hardware clock timer is stored in CLK_TCK
  // (sometimes this is already defined as preprocessor constant)
#if !defined(_WIN32) && !defined(CLK_TCK)
  static const long CLK_TCK; // define on Unix stations if neccessary
#endif
};

} // end namespace wsi

#endif // _WSI_CLOCK_HPP_
