///////////////////////////////////////////////////////////////////////////////
//
// Clock.cpp - multiplatform Clock class (implementation)
//
// last updated: Mon 12/06/1999
//
// +--------------------------------------------------------------------------+
// | Roland Weiss, WSI-CA         | eMail: weissr@informatik.uni-tuebingen.de |
// | University of Tuebingen      |      : weissr@uni-tuebingen.de            |
// | Sand 13, Room 218            |      : roland.weiss@uni-tuebingen.de      |
// | 72076 Tuebingen, Germany     | Tel  : +49 (0)7071 2974009                |
// |                              | Fax  : +49 (0)7071 295958                 |
// | WWW: http://www-ca.informatik.uni-tuebingen.de/people/weissr/weissr.html |
// +--------------------------------------------------------------------------+
//
///////////////////////////////////////////////////////////////////////////////

#include "Clock.hpp"

namespace wsi {

// initialize static constant CLK_TCK if necessary with Unix system call
#if !defined(_WIN32) && !defined(CLK_TCK) 
const long Clock::CLK_TCK = sysconf(_SC_CLK_TCK);
#endif

// default constructor, initializes internal data to current time
Clock::Clock() {
  RW_TIME_FUNC(&clock); // get current time
}
// copy constructor, sets new Clock object's time to given one
Clock::Clock(const Clock& cl) {
  clock = cl.clock;
}

// assignment operator, sets new Clock object's time to given one
Clock& Clock::operator=(const Clock& cl) {
  clock = cl.clock;
  return *this;
}

// relational operator, test two Clock objects against each other
bool Clock::operator==(const Clock& cl) {
#ifdef _WIN32 // Windows
  if ((clock.time == cl.clock.time) && (clock.millitm == cl.clock.millitm))
    return true;
  else return false;
#else         // Unix
  if (clock.tms_utime == cl.clock.tms_utime) return true;
  else return false;
#endif // _WIN32
}
bool Clock::operator<(const Clock& cl) {
#ifdef _WIN32 // Windows
  if (clock.time < cl.clock.time) return true;
  if (clock.time > cl.clock.time) return false;
  if (clock.millitm < cl.clock.millitm) return true;
  else return false;
#else         // Unix
  if (clock.tms_utime < cl.clock.tms_utime) return true;
  else return false;
#endif // _WIN32
}
bool Clock::operator>(const Clock& cl) {
  if ((*this) == cl) return false;
  else return !((*this) < cl);
}
bool Clock::operator<=(const Clock& cl) { return !((*this) > cl); }
bool Clock::operator>=(const Clock& cl) { return !((*this) < cl); }

// reset the Clock object's internal time to the current one
void Clock::refresh() {
  RW_TIME_FUNC(&clock); // get current time
}

// calculate the period of time passed between two clock instances in ms
unsigned long Clock::diff(const Clock& cl) {
#ifdef _WIN32 // Windows
  if ((*this) < cl)
    return (cl.clock.time-clock.time)*1000 + (cl.clock.millitm-clock.millitm);
  else
    return (clock.time-cl.clock.time)*1000 + (clock.millitm-cl.clock.millitm);
#else         // Unix
  if ((*this) < cl)
    return (cl.clock.tms_utime-clock.tms_utime)*1000/CLK_TCK;
  else
    return (clock.tms_utime-cl.clock.tms_utime)*1000/CLK_TCK;
#endif // _WIN32
}

} // end namespace wsi
